

<?php $__env->startSection('title', 'Amicabre Travels | KodeHub Portfolio'); ?>
<?php $__env->startSection('meta_description', 'How KodeHub built a modern employee transport and fleet management platform for Amicabre Travels using Node.js.'); ?>

<?php $__env->startSection('content'); ?>


<section class="project-hero">
    <div class="project-hero-bg">
        <img src="images/portfolio/amicabre.png" 
             alt="Fleet Management"
             style="width:100%; height:100%; object-fit:cover;">
    </div>
    <div class="project-hero-overlay"></div>

    <div class="container project-hero-content">

        <a href="<?php echo e(route('portfolio')); ?>" class="back-link" style="color: rgba(255,255,255,0.65); margin-bottom: 2.5rem; display: inline-flex;">
            <i class="fa-solid fa-arrow-left"></i> Back to Portfolio
        </a>

        <div class="project-hero-tag">
            <i class="fa-solid fa-van-shuttle"></i>
            Transport Management
        </div>

        <h1 class="project-hero-title">Amicabre Travels</h1>
        <p class="project-hero-subtitle">
            A comprehensive web platform enabling corporate clients to book employee 
            transport, manage fleet operations, and track usage in real time.
        </p>

    </div>
</section>


<div class="project-meta-strip">
    <div class="container">
        <div class="project-meta-grid">
            <div class="project-meta-item">
                <p class="project-meta-label">Client</p>
                <p class="project-meta-value">Amicabre Travels</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Category</p>
                <p class="project-meta-value">Fleet Management</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Tech Stack</p>
                <p class="project-meta-value">Node.js · EJS · CSS</p>
            </div>
            <div class="project-meta-item">
                <p class="project-meta-label">Live Website</p>
                <p class="project-meta-value">
                    <a href="https://web-fes.amicabretravel.com" target="_blank" rel="noopener"
                       style="color: var(--color-primary-light); text-decoration: none;">
                        amicabretravel.com <i class="fa-solid fa-arrow-up-right-from-square" style="font-size: 0.875rem;"></i>
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>


<section class="section bg-cream" style="background-color: var(--color-cream);">
    <div class="container">
        <div class="project-body">

            
            <div class="project-main">

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Overview</p>
                    <h2 class="project-section-title">The Brief</h2>
                    <p class="project-section-text">
                        Amicabre Travels is a professional transport provider offering employee 
                        commute solutions for corporate clients across Nairobi and Kiambu. 
                        Managing dozens of vehicles, multiple companies, and shifting daily 
                        schedules demanded a purpose-built digital platform—not a workaround 
                        built on spreadsheets and phone calls.
                    </p>
                    <p class="project-section-text">
                        They engaged KodeHub to design and build a web platform that would 
                        bring structure to their operations, improve the client booking experience, 
                        and provide the business intelligence needed to run an efficient fleet.
                    </p>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Challenge</p>
                    <h2 class="project-section-title">The Problem to Solve</h2>
                    <p class="project-section-text">
                        Fleet management is inherently complex. Vehicles, drivers, routes, 
                        corporate accounts, individual employees, and billing cycles all 
                        need to interconnect. The platform had to be simultaneously intuitive 
                        for end-users booking transport and powerful enough for operations 
                        staff managing the backend.
                    </p>
                    <ul class="result-list" style="margin-top: var(--spacing-lg);">
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-calendar-check"></i></div>
                            <p class="result-text">Corporate clients needed self-service booking with visibility into availability and scheduling.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-map-location-dot"></i></div>
                            <p class="result-text">Fleet operators needed real-time oversight of vehicle assignments and employee transport usage.</p>
                        </li>
                        <li class="result-item">
                            <div class="result-icon"><i class="fa-solid fa-chart-bar"></i></div>
                            <p class="result-text">Management required consolidated reporting across multiple client accounts and vehicle types.</p>
                        </li>
                    </ul>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Our Solution</p>
                    <h2 class="project-section-title">What We Built</h2>
                    <p class="project-section-text">
                        We delivered a Node.js web application using EJS templating, structured 
                        around three distinct user experiences: the public-facing marketing site, 
                        a corporate client portal, and an internal fleet management dashboard.
                    </p>
                    <p class="project-section-text">
                        The public site presents Amicabre's services clearly and drives enquiries, 
                        with pages fully optimised with WebP imagery, responsive layouts, and semantic 
                        HTML for SEO performance. The client portal allows corporate HR teams to 
                        register employees, schedule transport, and view their account history.
                        The management dashboard gives Amicabre's operations team a live view 
                        of fleet utilization and upcoming bookings.
                    </p>
                </div>

                
                <div class="project-section fade-in-up">
                    <p class="project-section-eyebrow">Technology</p>
                    <h2 class="project-section-title">Built With</h2>
                    <ul class="tech-list">
                        <li class="tech-pill">
                            <i class="fa-brands fa-node-js"></i> Node.js
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-file-code"></i> EJS Templates
                        </li>
                        <li class="tech-pill">
                            <i class="fa-brands fa-css3-alt"></i> Responsive CSS
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-image"></i> WebP Optimisation
                        </li>
                        <li class="tech-pill">
                            <i class="fa-solid fa-magnifying-glass-chart"></i> SEO Best Practices
                        </li>
                    </ul>
                </div>

            </div>

            
            <aside class="project-sidebar">

                
                <div class="sidebar-card fade-in-up">
                    <h3 class="sidebar-card-title">View the Live Platform</h3>
                    <p style="color: var(--text-secondary); font-size: 0.9375rem; line-height: 1.75; margin-bottom: var(--spacing-md);">
                        The platform is live and actively serving Amicabre's corporate clients.
                    </p>
                    <a href="https://web-fes.amicabretravel.com" target="_blank" rel="noopener" class="btn-visit">
                        Visit amicabretravel.com
                        <i class="fa-solid fa-arrow-up-right-from-square"></i>
                    </a>
                </div>

                
                <div class="sidebar-card fade-in-up">
                    <h3 class="sidebar-card-title">Project Details</h3>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Deliverable</span>
                        <span class="sidebar-stat-value">Web Platform</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Industry</span>
                        <span class="sidebar-stat-value">Transport</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Platform</span>
                        <span class="sidebar-stat-value">Web</span>
                    </div>
                    <div class="sidebar-stat">
                        <span class="sidebar-stat-label">Location</span>
                        <span class="sidebar-stat-value">Nairobi, Kenya</span>
                    </div>
                </div>

                
                <div class="sidebar-card fade-in-up" style="background: linear-gradient(135deg, #8B9B7E, #6B7B5E); border: none;">
                    <h3 style="font-family: 'Cormorant Garamond', serif; font-size: 1.5rem; font-weight: 300; color: white; margin-bottom: 0.75rem;">Need a management platform?</h3>
                    <p style="color: rgba(255,255,255,0.85); font-size: 0.9375rem; line-height: 1.7; margin-bottom: var(--spacing-md);">
                        We build systems that simplify complex operations.
                    </p>
                    <a href="<?php echo e(route('contact')); ?>" class="btn-visit" style="background-color: rgba(255,255,255,0.15); border: 1px solid rgba(255,255,255,0.3);">
                        Start a Conversation
                        <i class="fa-solid fa-arrow-right"></i>
                    </a>
                </div>

            </aside>

        </div>
    </div>
</section>


<section class="section bg-light">
    <div class="container">
        <div class="section-header fade-in-up">
            <div class="section-badge">More Work</div>
            <h2 class="section-title">Other Projects</h2>
        </div>
        <div class="other-projects-grid">

            <a href="<?php echo e(route('portfolio.picforest')); ?>" class="project-card fade-in-up">
                <img src="https://images.unsplash.com/photo-1542744173-8e7e53415bb0?q=80&w=2070&auto=format&fit=crop"
                     alt="Photography Platform"
                     style="width: 100%; height: 280px; object-fit: cover;">
                <div class="project-content">
                    <h3 class="project-title">Picforest Photography</h3>
                    <p class="project-description">High-performance photography portfolio website.</p>
                </div>
            </a>

            <a href="<?php echo e(route('portfolio.staffhub')); ?>" class="project-card fade-in-up">
                <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?q=80&w=2070&auto=format&fit=crop"
                     alt="HR Management"
                     style="width: 100%; height: 280px; object-fit: cover;">
                <div class="project-content">
                    <h3 class="project-title">StaffHub</h3>
                    <p class="project-description">Complete HR & payroll management system.</p>
                </div>
            </a>

        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) entry.target.classList.add('visible');
        });
    }, { threshold: 0.1, rootMargin: '0px 0px -60px 0px' });
    document.querySelectorAll('.fade-in-up').forEach(el => observer.observe(el));
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/portfolio/amicabre.blade.php ENDPATH**/ ?>