
<header class="site-header" id="site-header">
    <a href="<?php echo e(route('welcome')); ?>" class="nav-logo" id="nav-logo">
        <div class="logo-mark">KH</div>
        KodeHub
    </a>

    <nav class="nav-links" id="nav-links">
        <a href="<?php echo e(route('services')); ?>" class="nav-link <?php echo e(request()->routeIs('services') ? 'active' : ''); ?>">Services</a>
        <a href="<?php echo e(route('portfolio')); ?>" class="nav-link <?php echo e(request()->routeIs('portfolio*') ? 'active' : ''); ?>">Work</a>
        <a href="<?php echo e(route('about')); ?>" class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>">About</a>
        <a href="<?php echo e(route('contact')); ?>" class="nav-cta">Start a Project</a>
    </nav>

    <button class="nav-toggle" id="nav-toggle" aria-label="Toggle navigation">
        <span></span>
        <span></span>
        <span></span>
    </button>
</header>


<div class="nav-drawer" id="nav-drawer">
    <a href="<?php echo e(route('services')); ?>" class="nav-link">Services</a>
    <a href="<?php echo e(route('portfolio')); ?>" class="nav-link">Work</a>
    <a href="<?php echo e(route('about')); ?>" class="nav-link">About</a>
    <a href="<?php echo e(route('contact')); ?>" class="nav-link">Contact</a>
</div>

<script>
    (function() {
        const header = document.getElementById('site-header');
        const logo = document.getElementById('nav-logo');
        const links = document.querySelectorAll('#nav-links .nav-link');
        const cta = document.querySelector('#nav-links .nav-cta');
        const toggle = document.getElementById('nav-toggle');
        const drawer = document.getElementById('nav-drawer');

        // Determine if hero page (dark header needed)
        const isHeroPage = document.querySelector('.hero') !== null;
        
        if (isHeroPage) {
            header.classList.add('site-header--dark');
            logo.classList.add('nav-logo--light');
            links.forEach(l => l.classList.add('nav-link--light'));
            if (cta) cta.classList.add('nav-cta--light');
            toggle.classList.add('nav-toggle--light');
        }

        window.addEventListener('scroll', function() {
            if (window.scrollY > 60) {
                header.classList.add('scrolled');
                logo.classList.remove('nav-logo--light');
                links.forEach(l => l.classList.remove('nav-link--light'));
                if (cta) cta.classList.remove('nav-cta--light');
                toggle.classList.remove('nav-toggle--light');
            } else if (isHeroPage) {
                header.classList.remove('scrolled');
                logo.classList.add('nav-logo--light');
                links.forEach(l => l.classList.add('nav-link--light'));
                if (cta) cta.classList.add('nav-cta--light');
                toggle.classList.add('nav-toggle--light');
            }
        }, { passive: true });

        toggle.addEventListener('click', function() {
            drawer.classList.toggle('open');
            document.body.style.overflow = drawer.classList.contains('open') ? 'hidden' : '';
        });

        drawer.querySelectorAll('.nav-link').forEach(function(link) {
            link.addEventListener('click', function() {
                drawer.classList.remove('open');
                document.body.style.overflow = '';
            });
        });
    })();
</script><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/partials/header.blade.php ENDPATH**/ ?>