

<?php $__env->startSection('title', 'Contact | KodeHub — Start a Project or Request a Consultation'); ?>
<?php $__env->startSection('meta_description', 'Get in touch with KodeHub to discuss your project. We respond within 24 hours. Located in Kiambu, Kenya, serving clients locally and internationally.'); ?>

<?php $__env->startSection('content'); ?>


<div class="page-hero page-hero--dark">
    <div class="container">
        <span class="eyebrow" style="color:var(--accent-light);">Get in Touch</span>
        <h1 class="page-hero__title" style="color:white;">
            Let's start a
            <em style="font-style:italic; color:var(--accent-light);">conversation.</em>
        </h1>
        <p class="page-hero__lead">
            Whether you have a detailed brief or simply an idea you'd like to explore,
            we're here to listen. Share your situation with us and we'll respond within 24 hours.
        </p>
    </div>
</div>


<section class="section bg-paper-cool">
    <div class="container">

        <div class="contact-layout">

            
            <div class="reveal">

                <h2 style="font-family:var(--font-display); font-size:2rem; font-weight:400; margin-bottom:0.75rem; letter-spacing:-0.02em;">
                    Why work with KodeHub
                </h2>
                <p style="color:var(--ink-muted); font-size:1.0625rem; font-weight:300; line-height:1.85; margin-bottom:2.5rem; max-width:420px;">
                    We've helped over 30 organizations build digital infrastructure
                    they still rely on. Here's what they value about working with us.
                </p>

                <div style="margin-bottom:2.5rem;">
                    <div style="display:flex; gap:1rem; margin-bottom:1.5rem; align-items:flex-start;">
                        <div style="width:36px; height:36px; border:1px solid var(--accent-pale); display:flex; align-items:center; justify-content:center; flex-shrink:0; color:var(--accent); font-size:0.875rem; margin-top:2px;">
                            <i class="fa-solid fa-compass-drafting"></i>
                        </div>
                        <div>
                            <h4 style="font-size:1.0625rem; font-weight:500; margin-bottom:0.375rem;">We align technology to your goals</h4>
                            <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; line-height:1.7;">
                                Every feature we recommend serves a clear business objective. We don't build for the sake of building.
                            </p>
                        </div>
                    </div>
                    <div style="display:flex; gap:1rem; margin-bottom:1.5rem; align-items:flex-start;">
                        <div style="width:36px; height:36px; border:1px solid var(--accent-pale); display:flex; align-items:center; justify-content:center; flex-shrink:0; color:var(--accent); font-size:0.875rem; margin-top:2px;">
                            <i class="fa-solid fa-shield-halved"></i>
                        </div>
                        <div>
                            <h4 style="font-size:1.0625rem; font-weight:500; margin-bottom:0.375rem;">Security and performance are defaults</h4>
                            <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; line-height:1.7;">
                                Both are built into our architecture from day one—never patched in later.
                            </p>
                        </div>
                    </div>
                    <div style="display:flex; gap:1rem; margin-bottom:1.5rem; align-items:flex-start;">
                        <div style="width:36px; height:36px; border:1px solid var(--accent-pale); display:flex; align-items:center; justify-content:center; flex-shrink:0; color:var(--accent); font-size:0.875rem; margin-top:2px;">
                            <i class="fa-solid fa-handshake"></i>
                        </div>
                        <div>
                            <h4 style="font-size:1.0625rem; font-weight:500; margin-bottom:0.375rem;">Transparent, honest communication</h4>
                            <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; line-height:1.7;">
                                No hidden costs, inflated timelines, or vague deliverables.
                                You always know where your project stands.
                            </p>
                        </div>
                    </div>
                    <div style="display:flex; gap:1rem; align-items:flex-start;">
                        <div style="width:36px; height:36px; border:1px solid var(--accent-pale); display:flex; align-items:center; justify-content:center; flex-shrink:0; color:var(--accent); font-size:0.875rem; margin-top:2px;">
                            <i class="fa-solid fa-headset"></i>
                        </div>
                        <div>
                            <h4 style="font-size:1.0625rem; font-weight:500; margin-bottom:0.375rem;">We remain engaged post-launch</h4>
                            <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; line-height:1.7;">
                                Deployment is the beginning of the relationship, not the end of the contract.
                            </p>
                        </div>
                    </div>
                </div>

                
                <div>
                    <div class="contact-info__item">
                        <div class="contact-info__icon">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div>
                            <p class="contact-info__label">Email</p>
                            <p class="contact-info__value">
                                <a href="mailto:info@kodehub.com">info@kodehub.com</a>
                            </p>
                        </div>
                    </div>
                    <div class="contact-info__item">
                        <div class="contact-info__icon">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        <div>
                            <p class="contact-info__label">Phone</p>
                            <p class="contact-info__value">
                                <a href="tel:+254700000000">+254 700 000 000</a>
                            </p>
                        </div>
                    </div>
                    <div class="contact-info__item">
                        <div class="contact-info__icon">
                            <i class="fa-solid fa-location-dot"></i>
                        </div>
                        <div>
                            <p class="contact-info__label">Location</p>
                            <p class="contact-info__value">Kiambu, Kenya</p>
                        </div>
                    </div>
                    <div class="contact-info__item">
                        <div class="contact-info__icon">
                            <i class="fa-regular fa-clock"></i>
                        </div>
                        <div>
                            <p class="contact-info__label">Response Time</p>
                            <p class="contact-info__value">Within 24 hours</p>
                        </div>
                    </div>
                </div>

            </div>

            
            <div class="reveal reveal-delay-2">

                <div style="background:var(--white); padding:clamp(2rem,4vw,3rem); border:1px solid var(--rule);">

                    <h3 style="font-family:var(--font-display); font-size:1.625rem; font-weight:400; margin-bottom:0.5rem;">
                        Send us a message
                    </h3>
                    <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; margin-bottom:2rem;">
                        Describe your project and we'll get back to you with an honest assessment and next steps.
                    </p>

                    <?php if(session('success')): ?>
                        <div class="form-success">
                            <i class="fa-solid fa-circle-check"></i>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('contact.store')); ?>">
                        <?php echo csrf_field(); ?>

                        <div style="display:grid; grid-template-columns:1fr 1fr; gap:1.25rem;">
                            <div class="form-field">
                                <label class="form-label">Full Name <span style="color:var(--accent);">*</span></label>
                                <input type="text"
                                       name="name"
                                       value="<?php echo e(old('name')); ?>"
                                       class="form-input"
                                       placeholder="Jane Doe"
                                       required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="form-error"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-field">
                                <label class="form-label">Phone Number</label>
                                <input type="tel"
                                       name="phone"
                                       value="<?php echo e(old('phone')); ?>"
                                       class="form-input"
                                       placeholder="+254 700 000 000">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="form-error"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="form-field">
                            <label class="form-label">Email Address <span style="color:var(--accent);">*</span></label>
                            <input type="email"
                                   name="email"
                                   value="<?php echo e(old('email')); ?>"
                                   class="form-input"
                                   placeholder="jane@company.com"
                                   required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="form-error"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-field">
                            <label class="form-label">Service of Interest</label>
                            <select name="service" class="form-select">
                                <option value="">Please select a service</option>
                                <option value="Web Development" <?php echo e(old('service') == 'Web Development' ? 'selected' : ''); ?>>Web Development</option>
                                <option value="Mobile Applications" <?php echo e(old('service') == 'Mobile Applications' ? 'selected' : ''); ?>>Mobile Applications</option>
                                <option value="Enterprise Systems" <?php echo e(old('service') == 'Enterprise Systems' ? 'selected' : ''); ?>>Enterprise Systems (ERP)</option>
                                <option value="POS Systems" <?php echo e(old('service') == 'POS Systems' ? 'selected' : ''); ?>>Point of Sale Systems</option>
                                <option value="Consulting" <?php echo e(old('service') == 'Consulting' ? 'selected' : ''); ?>>Technology Consulting</option>
                                <option value="Other" <?php echo e(old('service') == 'Other' ? 'selected' : ''); ?>>Other</option>
                            </select>
                            <?php $__errorArgs = ['service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="form-error"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-field">
                            <label class="form-label">Project Details <span style="color:var(--accent);">*</span></label>
                            <textarea name="message"
                                      class="form-textarea"
                                      placeholder="Tell us about your project—what you're trying to achieve, your timeline, and any specific requirements or constraints..."
                                      required><?php echo e(old('message')); ?></textarea>
                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="form-error"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button type="submit" class="btn btn-primary" style="width:100%; justify-content:center;">
                            Send Message
                            <i class="fa-solid fa-paper-plane fa-xs"></i>
                        </button>

                    </form>
                </div>

            </div>

        </div>

    </div>
</section>


<section class="section--sm bg-paper-warm border-top">
    <div class="container">
        <div style="margin-bottom:2rem;" class="reveal">
            <span class="eyebrow">Our Location</span>
            <h2 style="font-family:var(--font-display); font-size:1.75rem; font-weight:400; margin-top:0.5rem;">
                Kiambu, Kenya
            </h2>
            <p style="font-size:0.9375rem; color:var(--ink-muted); font-weight:300; margin-top:0.5rem;">
                Serving clients locally and internationally.
            </p>
        </div>
        <div class="reveal">
            <iframe
                class="map-embed"
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d63820.84414287634!2d36.783619!3d-1.171521!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f3f3c3c3c3c3d%3A0x3c3c3c3c3c3c3c3c!2sKiambu%2C%20Kenya!5e0!3m2!1sen!2ske!4v1234567890"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"
                title="KodeHub office location in Kiambu, Kenya">
            </iframe>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/pages/contact.blade.php ENDPATH**/ ?>