

<?php $__env->startSection('title', 'Dashboard | KodeHub Admin'); ?>
<?php $__env->startSection('page_title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<div style="display:grid; grid-template-columns:repeat(3,1fr); gap:1px; background:var(--rule); border:1px solid var(--rule); margin-bottom:2rem;">
    <div class="admin-stat-card">
        <p class="admin-stat-card__label">Total Projects</p>
        <div class="admin-stat-card__num"><?php echo e($projectCount ?? 3); ?></div>
    </div>
    <div class="admin-stat-card">
        <p class="admin-stat-card__label">Unread Messages</p>
        <div class="admin-stat-card__num"><?php echo e($unreadMessages ?? 0); ?></div>
    </div>
    <div class="admin-stat-card">
        <p class="admin-stat-card__label">System Status</p>
        <div style="display:flex; align-items:center; gap:0.5rem; margin-top:0.25rem;">
            <span style="width:8px; height:8px; background:#22c55e; border-radius:50%; display:inline-block;"></span>
            <span style="font-size:1rem; color:#166534; font-weight:400;">Operational</span>
        </div>
    </div>
</div>

<div style="display:grid; grid-template-columns:1fr 1fr; gap:1.5rem;">
    <div class="admin-card">
        <h3 style="font-family:var(--font-display); font-size:1.125rem; font-weight:400; margin-bottom:1.25rem;">
            Quick Actions
        </h3>
        <div style="display:flex; flex-direction:column; gap:0.5rem;">
            <a href="<?php echo e(route('admin.messages')); ?>" class="admin-btn admin-btn--outline" style="justify-content:center;">
                <i class="fa-solid fa-inbox"></i> View Messages
            </a>
            <a href="<?php echo e(url('/admin/projects/create')); ?>" class="admin-btn admin-btn--primary" style="justify-content:center;">
                <i class="fa-solid fa-plus"></i> Add Project
            </a>
        </div>
    </div>

    <div class="admin-card">
        <h3 style="font-family:var(--font-display); font-size:1.125rem; font-weight:400; margin-bottom:1.25rem;">
            Site Links
        </h3>
        <div style="display:flex; flex-direction:column; gap:0.375rem;">
            <?php $__currentLoopData = [['Home', 'welcome'], ['Services', 'services'], ['Portfolio', 'portfolio'], ['Contact', 'contact']]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as [$label, $route]): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route($route)); ?>" target="_blank"
               style="display:flex; align-items:center; justify-content:space-between; padding:0.5rem 0; border-bottom:1px solid var(--rule); font-size:0.9375rem; color:var(--ink-soft);">
                <?php echo e($label); ?>

                <i class="fa-solid fa-arrow-up-right-from-square" style="font-size:0.6875rem; color:var(--ink-faint);"></i>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\calton\Herd\kodehub\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>