<?php 

use App\Http\Controllers\PageController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\ProjectController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Auth;


Route::get('/', [PageController::class, 'welcome'])->name('welcome');
Route::get('/services', [PageController::class, 'services'])->name('services');
Route::get('/portfolio', [PageController::class, 'portfolio'])->name('portfolio');
Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');

Route::post('/contact', [ContactController::class, 'store'])->name('contact.store');


// Portfolio projects
Route::get('/portfolio/picforest', [PageController::class, 'picforest'])->name('portfolio.picforest');
Route::get('/portfolio/amicabre', [PageController::class, 'amicabre'])->name('portfolio.amicabre');
Route::get('/portfolio/staffhub', [PageController::class, 'staffhub'])->name('portfolio.staffhub');

// Admin
Route::get('/admin/login', [AuthController::class, 'login'])->name('admin.login');
Route::post('/admin/login', [AuthController::class, 'authenticate']);

Route::middleware(['auth'])->prefix('admin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/messages', [MessageController::class, 'index'])->name('admin.messages');
    Route::get('/messages/{message}', [MessageController::class, 'show'])->name('admin.messages.show');

    // Projects
    Route::get('/projects', [ProjectController::class, 'index'])->name('admin.projects');
    Route::get('/projects/create', [ProjectController::class, 'create']);
    Route::post('/projects', [ProjectController::class, 'store']);

    Route::post('/logout', function () {
        Auth::logout();
        request()->session()->invalidate();
        request()->session()->regenerateToken();
        return redirect('/admin/login');
    })->name('logout');
});