@extends('layouts.app')

@section('title', 'Services | KodeHub — Web, Mobile, ERP & POS Development')
@section('meta_description', 'KodeHub delivers bespoke web development, mobile applications, custom ERP systems, and POS solutions engineered for performance, security, and longevity.')

@section('content')

{{-- ============================================================
     PAGE HERO
============================================================ --}}
<div class="page-hero page-hero--dark">
    <div class="container">
        <span class="eyebrow" style="color:var(--accent-light);">What We Build</span>
        <h1 class="page-hero__title" style="color:white;">
            Digital solutions<br>
            <em style="font-style:italic; color:var(--accent-light);">crafted with intent.</em>
        </h1>
        <p class="page-hero__lead">
            At KodeHub we specialize in four interconnected disciplines—each supported
            by a mature methodology and a team that takes the long view on quality.
        </p>
    </div>
</div>

{{-- ============================================================
     SERVICES DETAIL
============================================================ --}}
<section class="section bg-paper-cool">
    <div class="container">

        {{-- 01 Web Development --}}
        <div class="service-detail reveal">
            <div>
                <span class="service-detail__badge">Service / 01</span>
                <h2 class="service-detail__title">Web Development</h2>
                <p class="service-detail__desc">
                    We design and engineer web platforms that balance aesthetic refinement
                    with robust, scalable architecture. Whether you need a marketing presence
                    that converts or a complex multi-tenant SaaS application, we build it
                    on solid foundations using Laravel and modern front-end tooling.
                </p>
                <ul class="service-detail__list">
                    <li><i class="fa-solid fa-check"></i><span>Custom Laravel and PHP applications with clean, documented architecture</span></li>
                    <li><i class="fa-solid fa-check"></i><span>SEO-optimized and performance-tuned for maximum organic reach</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Enterprise-grade authentication, authorization, and role management</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Responsive design with a mobile-first approach throughout</span></li>
                    <li><i class="fa-solid fa-check"></i><span>API-first architecture enabling seamless third-party integrations</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Comprehensive testing suites and CI/CD pipeline configuration</span></li>
                </ul>
                <div class="service-detail__ideal">
                    <p class="service-detail__ideal-label">Ideal for</p>
                    <p>Businesses, startups, educational institutions, and service providers requiring reliable,
                    scalable web solutions that grow in sophistication alongside their needs.</p>
                </div>
            </div>
            <div class="service-detail__visual">
                <i class="fa-solid fa-code service-detail__visual-icon"></i>
            </div>
        </div>

        {{-- 02 Mobile --}}
        <div class="service-detail reveal">
            <div>
                <span class="service-detail__badge">Service / 02</span>
                <h2 class="service-detail__title">Mobile Applications</h2>
                <p class="service-detail__desc">
                    We build cross-platform mobile applications that deliver native-grade
                    performance on both iOS and Android from a single, maintainable codebase—
                    reducing cost without sacrificing experience quality.
                </p>
                <ul class="service-detail__list">
                    <li><i class="fa-solid fa-check"></i><span>Single codebase deployment across iOS and Android</span></li>
                    <li><i class="fa-solid fa-check"></i><span>RESTful API architecture for flexibility and scalability</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Secure user authentication with multi-factor options</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Performance-optimized UX with fluid animations and transitions</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Offline-first capabilities for uninterrupted field use</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Push notifications, analytics integration, and crash reporting</span></li>
                </ul>
                <div class="service-detail__ideal">
                    <p class="service-detail__ideal-label">Ideal for</p>
                    <p>Startups, logistics companies, field service operations, and organizations
                    requiring powerful mobile tools for their teams or end customers.</p>
                </div>
            </div>
            <div class="service-detail__visual">
                <i class="fa-solid fa-mobile-screen-button service-detail__visual-icon"></i>
            </div>
        </div>

        {{-- 03 ERP --}}
        <div class="service-detail reveal">
            <div>
                <span class="service-detail__badge">Service / 03</span>
                <h2 class="service-detail__title">Enterprise Resource Planning</h2>
                <p class="service-detail__desc">
                    We design and implement custom ERP systems built around your actual
                    workflows—not the other way around. The result is a coherent platform
                    that centralizes operations, automates repetitive tasks, and surfaces
                    the intelligence your leadership team needs to act decisively.
                </p>
                <ul class="service-detail__list">
                    <li><i class="fa-solid fa-check"></i><span>Integrated HR, payroll, inventory, and operations management</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Granular role-based access control and audit trails</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Advanced reporting and real-time business intelligence dashboards</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Workflow automation to eliminate manual, error-prone processes</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Modular architecture allowing phased implementation and expansion</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Comprehensive onboarding, training, and documentation support</span></li>
                </ul>
                <div class="service-detail__ideal">
                    <p class="service-detail__ideal-label">Ideal for</p>
                    <p>Small to medium enterprises and corporate organizations with complex internal
                    processes that have outgrown off-the-shelf software solutions.</p>
                </div>
            </div>
            <div class="service-detail__visual">
                <i class="fa-solid fa-diagram-project service-detail__visual-icon"></i>
            </div>
        </div>

        {{-- 04 POS --}}
        <div class="service-detail reveal">
            <div>
                <span class="service-detail__badge">Service / 04</span>
                <h2 class="service-detail__title">Point of Sale Systems</h2>
                <p class="service-detail__desc">
                    Our POS solutions are engineered for speed, accuracy, and resilience—
                    combining intuitive interfaces that require minimal training with powerful
                    inventory management and the analytics your management team needs.
                </p>
                <ul class="service-detail__list">
                    <li><i class="fa-solid fa-check"></i><span>Real-time sales tracking with automatic inventory synchronization</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Multi-user support with customizable operator permissions</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Detailed sales analytics and shift performance reporting</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Offline mode ensuring uninterrupted operations during outages</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Payment gateway integration and digital receipt management</span></li>
                    <li><i class="fa-solid fa-check"></i><span>Multi-location support with centralized inventory oversight</span></li>
                </ul>
                <div class="service-detail__ideal">
                    <p class="service-detail__ideal-label">Ideal for</p>
                    <p>Retail stores, supermarkets, pharmacies, restaurants, and any business that
                    requires efficient, reliable point-of-sale operations at any scale.</p>
                </div>
            </div>
            <div class="service-detail__visual">
                <i class="fa-solid fa-cash-register service-detail__visual-icon"></i>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     PROCESS
============================================================ --}}
<section class="section bg-paper-warm border-top">
    <div class="container">

        <div class="section-header--center reveal">
            <span class="eyebrow">Our Process</span>
            <h2 class="section-title">How every project unfolds</h2>
            <p class="section-lead">
                A refined delivery framework that ensures consistent quality,
                transparent collaboration, and predictable outcomes.
            </p>
        </div>

        <div class="process-steps">
            <div class="process-step reveal">
                <div class="process-step__num">01</div>
                <h3 class="process-step__title">Discovery &amp; Strategy</h3>
                <p class="process-step__desc">
                    We immerse ourselves in your business—understanding objectives,
                    constraints, and users before a single line of code is written.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-1">
                <div class="process-step__num">02</div>
                <h3 class="process-step__title">Design &amp; Architecture</h3>
                <p class="process-step__desc">
                    User experience and technical architecture are designed in parallel—
                    ensuring the system is both intuitive and structurally sound.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-2">
                <div class="process-step__num">03</div>
                <h3 class="process-step__title">Development &amp; Testing</h3>
                <p class="process-step__desc">
                    Built iteratively with rigorous quality assurance at every stage—
                    performance, security, and edge cases are never left to chance.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-3">
                <div class="process-step__num">04</div>
                <h3 class="process-step__title">Launch &amp; Partnership</h3>
                <p class="process-step__desc">
                    Seamless deployment, comprehensive handover, and ongoing support
                    ensure your investment continues to deliver value over time.
                </p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     TECHNOLOGY STACK
============================================================ --}}
<section class="section bg-paper-cool border-top">
    <div class="container">

        <div class="section-header--center reveal">
            <span class="eyebrow">Technology Stack</span>
            <h2 class="section-title">Proven tools, modern practices</h2>
            <p class="section-lead">
                We work with an established, well-supported technology stack—
                chosen for reliability, developer experience, and long-term maintainability.
            </p>
        </div>

        <div class="tech-grid">
            <div class="tech-card reveal">
                <div class="tech-card__icon"><i class="fa-brands fa-laravel"></i></div>
                <h4 class="tech-card__name">Laravel &amp; PHP</h4>
                <p class="tech-card__desc">Our primary backend framework for secure, scalable web applications.</p>
            </div>
            <div class="tech-card reveal reveal-delay-1">
                <div class="tech-card__icon"><i class="fa-brands fa-react"></i></div>
                <h4 class="tech-card__name">React &amp; Vue.js</h4>
                <p class="tech-card__desc">Modern JavaScript frameworks for dynamic, responsive front-ends.</p>
            </div>
            <div class="tech-card reveal reveal-delay-2">
                <div class="tech-card__icon"><i class="fa-solid fa-database"></i></div>
                <h4 class="tech-card__name">MySQL &amp; PostgreSQL</h4>
                <p class="tech-card__desc">Robust relational databases for reliable, structured data management.</p>
            </div>
            <div class="tech-card reveal reveal-delay-3">
                <div class="tech-card__icon"><i class="fa-brands fa-aws"></i></div>
                <h4 class="tech-card__name">Cloud Infrastructure</h4>
                <p class="tech-card__desc">AWS and DigitalOcean deployments for enterprise-grade availability.</p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     CTA
============================================================ --}}
<div class="cta-banner">
    <div class="cta-banner__inner">
        <h2 class="cta-banner__title">
            Have a project in mind?
            <em>Let's talk.</em>
        </h2>
        <a href="{{ route('contact') }}" class="btn btn-primary">
            Request a Consultation
            <i class="fa-solid fa-arrow-right fa-xs"></i>
        </a>
    </div>
</div>

@endsection