@extends('layouts.app')

@section('title', 'About | KodeHub — Boutique Software Development Studio, Kenya')
@section('meta_description', 'KodeHub is a boutique software development studio in Kenya specializing in bespoke web applications, mobile platforms, and enterprise systems built to last.')

@section('content')

{{-- ============================================================
     ABOUT HERO — SPLIT LAYOUT
============================================================ --}}
<div class="about-hero-split">
    <div class="about-hero__content">
        <div style="position:relative; z-index:2;">
            <span class="eyebrow" style="color:var(--accent-light); margin-bottom:1.5rem; display:block;">About KodeHub</span>
            <h1 class="display-2" style="color:white; margin-bottom:1.5rem; max-width:520px;">
                A studio defined by
                <em style="font-style:italic; color:var(--accent-light);">what we refuse to compromise.</em>
            </h1>
            <p style="font-size:1.0625rem; color:rgba(255,255,255,0.6); line-height:1.85; max-width:440px; font-weight:300;">
                Founded on the belief that technology should serve business—not the reverse—
                KodeHub has spent over five years building software that clients still rely on
                years after launch.
            </p>
        </div>
    </div>
    <div class="about-hero__media">
        <img src="https://images.unsplash.com/photo-1531482615713-2afd69097998?q=85&w=1200&auto=format&fit=crop"
             alt="KodeHub studio environment"
             loading="eager">
    </div>
</div>

{{-- ============================================================
     STATS
============================================================ --}}
<div class="stats-row bg-paper-cool border-bottom" style="border-top:1px solid var(--rule);">
    <div class="stat-block reveal">
        <div class="stat-block__num">50+</div>
        <div class="stat-block__label">Projects delivered</div>
    </div>
    <div class="stat-block reveal reveal-delay-1">
        <div class="stat-block__num">30+</div>
        <div class="stat-block__label">Clients served</div>
    </div>
    <div class="stat-block reveal reveal-delay-2">
        <div class="stat-block__num">100%</div>
        <div class="stat-block__label">Client retention</div>
    </div>
    <div class="stat-block reveal reveal-delay-3">
        <div class="stat-block__num">5 yrs</div>
        <div class="stat-block__label">In business</div>
    </div>
</div>

{{-- ============================================================
     WHO WE ARE
============================================================ --}}
<section class="section bg-paper-cool">
    <div class="container">

        <div class="about-text-section reveal">
            <div>
                <span class="eyebrow">Who We Are</span>
                <h2 class="about-text-section__heading" style="margin-top:0.75rem;">The studio</h2>
            </div>
            <div class="about-text-section__body">
                <p>
                    KodeHub is a boutique software development studio based in Kiambu, Kenya.
                    We specialize in four disciplines—web applications, cross-platform mobile development,
                    enterprise resource planning, and point-of-sale systems—and we've chosen to remain
                    focused rather than broad, because depth produces better outcomes than breadth.
                </p>
                <p>
                    Our team brings together expertise in backend engineering, database architecture,
                    user experience design, and business process optimization. Every project is
                    treated as a long-term responsibility, not a one-time transaction.
                </p>
                <p>
                    We work primarily with organizations in Kenya and East Africa, though our client
                    base extends internationally. Size of client is less important to us than alignment
                    of values—we work best with organizations that share our conviction that good
                    software takes time, clear thinking, and genuine care.
                </p>
            </div>
        </div>

        <div class="about-text-section reveal">
            <div>
                <span class="eyebrow">Our Principles</span>
                <h2 class="about-text-section__heading" style="margin-top:0.75rem;">How we think</h2>
            </div>
            <div class="about-text-section__body">
                <p>
                    We believe technology is a means to an end, not an end in itself. Every architectural
                    decision, every design choice, and every line of code should serve a clear business
                    objective—if it doesn't, it shouldn't exist.
                </p>
                <p>
                    We build for the long term. This means writing clean, documented, testable code;
                    choosing established technologies over fashionable ones; and resisting the urge
                    to over-engineer. The systems we build five years ago still run well today—
                    that's the standard we hold ourselves to.
                </p>
                <p>
                    We communicate plainly. No jargon, no inflated estimates, no hiding behind process.
                    Our clients are adults running real organizations and they deserve honest, direct
                    information at every stage of the engagement.
                </p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     WHAT SETS US APART
============================================================ --}}
<section class="section bg-paper-warm border-top">
    <div class="container">

        <div class="section-header--center reveal">
            <span class="eyebrow">Our Distinction</span>
            <h2 class="section-title">What makes us different</h2>
            <p class="section-lead">
                We've chosen depth over breadth, craft over speed, and partnership over transaction.
                Here's what that means in practice.
            </p>
        </div>

        <div class="values-grid">
            <div class="value-card reveal">
                <div class="value-card__icon"><i class="fa-solid fa-sitemap"></i></div>
                <h3 class="value-card__title">Business-First Thinking</h3>
                <p class="value-card__desc">
                    We start with your business model and objectives, then work backwards to technology.
                    This produces systems that are actually useful, not just technically impressive.
                </p>
            </div>
            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon"><i class="fa-solid fa-chart-line"></i></div>
                <h3 class="value-card__title">Built for Longevity</h3>
                <p class="value-card__desc">
                    Clean code, comprehensive documentation, and sensible architecture mean your system
                    remains maintainable—and your team capable—years after we've delivered it.
                </p>
            </div>
            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon"><i class="fa-solid fa-user-shield"></i></div>
                <h3 class="value-card__title">Security by Design</h3>
                <p class="value-card__desc">
                    Security architecture is established at the beginning, not patched in at the end.
                    Every system we build undergoes security review before it's considered done.
                </p>
            </div>
            <div class="value-card reveal">
                <div class="value-card__icon"><i class="fa-solid fa-comments"></i></div>
                <h3 class="value-card__title">Transparent Communication</h3>
                <p class="value-card__desc">
                    Regular progress updates, honest assessments, and realistic timelines.
                    We treat our clients as partners, not stakeholders to be managed.
                </p>
            </div>
            <div class="value-card reveal reveal-delay-1">
                <div class="value-card__icon"><i class="fa-solid fa-rocket"></i></div>
                <h3 class="value-card__title">Performance Obsessed</h3>
                <p class="value-card__desc">
                    Every millisecond matters. We optimize queries, minimize asset payloads, and
                    tune infrastructure—because user experience is a product requirement, not a nice-to-have.
                </p>
            </div>
            <div class="value-card reveal reveal-delay-2">
                <div class="value-card__icon"><i class="fa-solid fa-handshake"></i></div>
                <h3 class="value-card__title">Ongoing Partnership</h3>
                <p class="value-card__desc">
                    Our engagement doesn't end at deployment. We remain available for support,
                    maintenance, and strategic guidance as your organization and its needs evolve.
                </p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     METHODOLOGY
============================================================ --}}
<section class="section bg-ink">
    <div class="container">

        <div class="section-header--center reveal" style="color:white;">
            <span class="eyebrow" style="color:var(--accent-light);">Methodology</span>
            <h2 class="section-title" style="color:white;">How we work</h2>
            <p class="section-lead" style="color:rgba(255,255,255,0.6); margin:0 auto;">
                A structured process that accommodates the reality that requirements evolve
                while maintaining the discipline that quality demands.
            </p>
        </div>

        <div class="process-steps" style="background:rgba(255,255,255,0.04); border-color:rgba(255,255,255,0.08);">
            <div class="process-step reveal" style="background:rgba(255,255,255,0.03); border-right:1px solid rgba(255,255,255,0.08);">
                <div class="process-step__num" style="color:rgba(255,255,255,0.12);">01</div>
                <h3 class="process-step__title" style="color:white;">Discovery &amp; Strategy</h3>
                <p class="process-step__desc" style="color:rgba(255,255,255,0.55);">
                    We invest significant time upfront understanding your organization, users, and goals
                    before proposing any solution. This phase defines everything that follows.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-1" style="background:rgba(255,255,255,0.03); border-right:1px solid rgba(255,255,255,0.08);">
                <div class="process-step__num" style="color:rgba(255,255,255,0.12);">02</div>
                <h3 class="process-step__title" style="color:white;">Design &amp; Architecture</h3>
                <p class="process-step__desc" style="color:rgba(255,255,255,0.55);">
                    UX and technical architecture are designed together—ensuring that what's beautiful
                    is also structurally sound and achievable within your timeline and budget.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-2" style="background:rgba(255,255,255,0.03); border-right:1px solid rgba(255,255,255,0.08);">
                <div class="process-step__num" style="color:rgba(255,255,255,0.12);">03</div>
                <h3 class="process-step__title" style="color:white;">Build &amp; Test</h3>
                <p class="process-step__desc" style="color:rgba(255,255,255,0.55);">
                    Iterative delivery with continuous testing and client feedback loops.
                    No surprises at the end—you see the work as it develops.
                </p>
            </div>
            <div class="process-step reveal reveal-delay-3" style="background:rgba(255,255,255,0.03);">
                <div class="process-step__num" style="color:rgba(255,255,255,0.12);">04</div>
                <h3 class="process-step__title" style="color:white;">Launch &amp; Sustain</h3>
                <p class="process-step__desc" style="color:rgba(255,255,255,0.55);">
                    Careful deployment, comprehensive training, and documented handover—
                    followed by ongoing support and strategic guidance.
                </p>
            </div>
        </div>

    </div>
</section>

{{-- ============================================================
     CTA
============================================================ --}}
<div class="cta-banner">
    <div class="cta-banner__inner">
        <h2 class="cta-banner__title">
            Ready to work with a studio
            <em>that gives a damn?</em>
        </h2>
        <a href="{{ route('contact') }}" class="btn btn-primary">
            Start a Conversation
            <i class="fa-solid fa-arrow-right fa-xs"></i>
        </a>
    </div>
</div>

@endsection