@extends('layouts.admin')

@section('title', 'Add Project | KodeHub Admin')
@section('page_title', 'Add Project')

@section('content')

<div style="max-width:640px;">
    <a href="{{ route('admin.projects') }}" class="admin-btn admin-btn--outline" style="margin-bottom:1.5rem; display:inline-flex;">
        <i class="fa-solid fa-arrow-left fa-xs"></i>
        Back to Projects
    </a>

    <div class="admin-card">
        <h2 style="font-family:var(--font-display); font-size:1.25rem; font-weight:400; margin-bottom:1.75rem;">
            New Portfolio Project
        </h2>

        @if($errors->any())
            <div style="background:rgba(192,57,43,0.07); border:1px solid rgba(192,57,43,0.2); padding:1rem 1.25rem; margin-bottom:1.5rem; font-size:0.9375rem; color:#c0392b;">
                <ul style="padding-left:1rem; list-style:disc;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ url('/admin/projects') }}">
            @csrf

            <div class="form-field">
                <label class="form-label">Project Title <span style="color:var(--accent);">*</span></label>
                <input type="text" name="title" value="{{ old('title') }}" class="form-input" placeholder="e.g. StaffHub HR Platform" required>
            </div>

            <div class="form-field">
                <label class="form-label">Client Name <span style="color:var(--accent);">*</span></label>
                <input type="text" name="client" value="{{ old('client') }}" class="form-input" placeholder="e.g. Amicabre Travels" required>
            </div>

            <div class="form-field">
                <label class="form-label">Project URL</label>
                <input type="url" name="url" value="{{ old('url') }}" class="form-input" placeholder="https://example.com">
            </div>

            <div class="form-field">
                <label class="form-label">Category</label>
                <select name="category" class="form-select">
                    <option value="">Select category</option>
                    <option value="Web Development" {{ old('category') == 'Web Development' ? 'selected' : '' }}>Web Development</option>
                    <option value="Mobile Application" {{ old('category') == 'Mobile Application' ? 'selected' : '' }}>Mobile Application</option>
                    <option value="Enterprise ERP" {{ old('category') == 'Enterprise ERP' ? 'selected' : '' }}>Enterprise ERP</option>
                    <option value="POS System" {{ old('category') == 'POS System' ? 'selected' : '' }}>POS System</option>
                </select>
            </div>

            <div class="form-field">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-textarea" style="min-height:120px;" placeholder="Brief description of the project and its outcomes...">{{ old('description') }}</textarea>
            </div>

            <div style="display:flex; gap:1rem;">
                <button type="submit" class="admin-btn admin-btn--primary">
                    <i class="fa-solid fa-check fa-xs"></i>
                    Save Project
                </button>
                <a href="{{ route('admin.projects') }}" class="admin-btn admin-btn--outline">
                    Cancel
                </a>
            </div>

        </form>
    </div>
</div>

@endsection