@extends('layouts.admin')

@section('title', 'Messages | KodeHub Admin')
@section('page_title', 'Contact Messages')

@section('content')

<div class="admin-card">
    <div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:1.5rem; padding-bottom:1rem; border-bottom:1px solid var(--rule);">
        <h2 style="font-family:var(--font-display); font-size:1.25rem; font-weight:400;">All Messages</h2>
        <span style="font-size:0.875rem; color:var(--ink-muted);">{{ $messages->total() ?? 0 }} total</span>
    </div>

    @if($messages->isEmpty())
        <div style="text-align:center; padding:3rem; color:var(--ink-muted);">
            <i class="fa-solid fa-inbox" style="font-size:2rem; margin-bottom:1rem; display:block; color:var(--ink-faint);"></i>
            No messages yet.
        </div>
    @else
        <table class="admin-table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Service</th>
                    <th>Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($messages as $msg)
                <tr>
                    <td>
                        <a href="{{ route('admin.messages.show', $msg) }}"
                           style="font-weight:400; color:var(--ink); transition:color 0.15s;"
                           onmouseover="this.style.color='var(--accent)'"
                           onmouseout="this.style.color='var(--ink)'">
                            {{ $msg->name }}
                        </a>
                    </td>
                    <td style="color:var(--ink-muted);">{{ $msg->email }}</td>
                    <td>
                        @if($msg->service)
                            <span class="admin-badge">{{ $msg->service }}</span>
                        @else
                            <span style="color:var(--ink-faint); font-size:0.875rem;">—</span>
                        @endif
                    </td>
                    <td style="color:var(--ink-muted); font-size:0.875rem;">{{ $msg->created_at->format('d M Y') }}</td>
                    <td>
                        @if(!$msg->is_read)
                            <span style="display:inline-flex; align-items:center; gap:0.375rem; font-size:0.8125rem; color:var(--accent);">
                                <span style="width:6px; height:6px; background:var(--accent); border-radius:50%;"></span>
                                New
                            </span>
                        @else
                            <span style="font-size:0.8125rem; color:var(--ink-faint);">Read</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div style="margin-top:1.5rem; padding-top:1.25rem; border-top:1px solid var(--rule);">
            {{ $messages->links() }}
        </div>
    @endif
</div>

@endsection