<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PageController extends Controller
{
    public function welcome() {
        return view('pages.welcome');
    }

    public function services() {
        return view('pages.services');
    }

    public function portfolio() {
        return view('pages.portfolio');
    }

    public function about() {
        return view('pages.about');
    }

    public function contact() {
        return view('pages.contact');


    }

    public function submitContact(Request $request)
    {
        $validated = $request->validate([
            'name'    => 'required|string|max:100',
            'email'   => 'required|email|max:150',
            'service' => 'required|string',
            'message' => 'required|string|min:10|max:1000',
        ]);

        /*
        * NEXT STEPS (later):
        * - Save to database
        * - Send email notification
        */

        return back()->with('success', 'Thank you! Your message has been sent. We’ll get back to you shortly.');
    }

    public function picforest() {
        return view('portfolio.picforest');
    }

    public function amicabre() {
        return view('portfolio.amicabre');
    }

    public function staffhub() {
        return view('portfolio.staffhub');
    }
}
