<?php

namespace App\Http\Controllers;

use App\Models\ContactMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:100',
            'email' => 'required|email',
            'subject' => 'nullable|string|max:150',
            'message' => 'required|string|min:10',
        ]);

        $message = ContactMessage::create($data);

        // Email notification
        Mail::to(config('mail.from.address'))
            ->send(new \App\Mail\ContactNotificationMail($message));

        return back()->with('success', 'Message sent successfully!');
    }
}
